package gov.cms.grouper.snf.lego;

import gov.cms.grouper.snf.model.CognitiveLevel;
import gov.cms.grouper.snf.model.table.CmgForPtOtRow;
import gov.cms.grouper.snf.model.table.CognitiveLevelRow;
import java.util.ArrayList;
import java.util.List;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class CsvHelperTest {

  @Test
  public void testGetRows() {
    CsvHelper<CognitiveLevelRow> helper = new CsvHelper<>(null, null, false);
    List<String> lines = new ArrayList<>();
    for (int i = 0; i < 5; i += 1) {
      lines.add("\"test" + i + "\",\"100\",\"\",\"" + i + "\",\"15\"");
    }

    List<String[]> result = helper.getRows(lines);

    for (int i = 0; i < result.size(); i += 1) {
      Assertions.assertEquals(result.get(i)[0], "test" + i);
      Assertions.assertEquals(Integer.parseInt(result.get(i)[3]), i);
    }

  }

  @Test
  public void testGetData() {
    CsvHelper<CmgForPtOtRow> helper = new CsvHelper<>(null, null, false);
    List<String[]> data = new ArrayList<>();
    for (int i = 0; i < 5; i++) {
      String[] row = new String[] {"test" + (i / 3), "100", null, "2", "8", "cmg" + i};
      data.add(row);
    }

    List<CmgForPtOtRow> result = helper.getData(CmgForPtOtRow.Builder.of(), data);

    for (int i = 0; i < result.size(); i += 1) {
      Assertions.assertEquals(result.get(i).getClinicalCategory(), data.get(i)[0]);
      Assertions.assertEquals(result.get(i).getLowVersion().toString(), data.get(i)[1]);
      Assertions.assertNull(data.get(i)[2]);
      Assertions.assertEquals(result.get(i).getFunctionScoreLow().toString(), data.get(i)[3]);
      Assertions.assertEquals(result.get(i).getFunctionScoreHigh().toString(), data.get(i)[4]);
      Assertions.assertEquals(result.get(i).getCmg(), data.get(i)[5]);
    }
  }

  @Test
  public void testLoad() {
    CsvHelper<CognitiveLevelRow> helper =
        new CsvHelper<>(null, CognitiveLevelRow.Builder.of(), false);
    List<String> lines = new ArrayList<>();
    for (int i = 0; i < 5; i += 1) {
      lines.add("\"Severely Impaired" + "\",\"100\",\"\",\"" + i + "\",\"15\"");
    }

    List<CognitiveLevelRow> result = helper.load(lines);

    for (int i = 0; i < result.size(); i += 1) {
      Assertions.assertEquals(result.get(i).getCognitiveLevel(), CognitiveLevel.SEVERELY_IMPARED);
      Assertions.assertEquals(result.get(i).getLowScore().intValue(), i);
    }
  }

}
